!=======================================================================
!
! $Id: setkin_smv2.h $
!
! CODE DEVELOPER
!   Peter Connell, LLNL
!   connell2@llnl.gov
!
! FILE
!   setkin_smv2.h
!
! DESCRIPTION
!   This include file contains the primary description of the chemical
!   mechanism in the form of SMV2 data statements.
!
!  Input mechanism:         GeosCCM_Combo_2015mechanism_orig.txt
!  Reaction dictionary:     GMI_reactions_JPL19.db
!  Setkin files generated:  Mon May 12 15:44:10 2025
!
!=======================================================================
!
!.... Species names
!

      data (NAMESP2(JGAS,1), JGAS = 0, 50) / &
     & "              ", "          A3O2", "          ACTA",  & 
     & "          ALD2", "          ALK4", "          ATO2",  & 
     & "          B3O2", "            Br", "          BrCl",  & 
     & "           BrO", "        BrONO2", "          C2H6",  & 
     & "          C3H8", "          CCl4", "        CF2Br2",  & 
     & "       CF2ClBr", "         CF3Br", "        CFC113",  & 
     & "        CFC114", "        CFC115", "         CFC11",  & 
     & "         CFC12", "          CH2O", "         CH3Br",  & 
     & "       CH3CCl3", "         CH3Cl", "           CH4",  & 
     & "           Cl2", "         Cl2O2", "            Cl",  & 
     & "           ClO", "        ClONO2", "            CO",  & 
     & "           EOH", "          ETO2", "           ETP",  & 
     & "          GLYC", "          GLYX", "             H",  & 
     & "            H2", "         H2402", "          H2O2",  & 
     & "           H2O", "           HAC", "           HBr",  & 
     & "      HCFC141b", "      HCFC142b", "        HCFC22",  & 
     & "           HCl", "         HCOOH", "          HNO2" /

      data (NAMESP2(JGAS,1), JGAS = 51, 101) / &
     & "          HNO3", "          HNO4", "           HO2",  & 
     & "          HOBr", "          HOCl", "          IALD",  & 
     & "          IAO2", "           IAP", "          INO2",  & 
     & "          INPN", "          ISN1", "          ISNP",  & 
     & "          ISOP", "           KO2", "          MACR",  & 
     & "          MAN2", "          MAO3", "          MAOP",  & 
     & "           MAP", "          MCO3", "           MEK",  & 
     & "          MGLY", "           MO2", "           MOH",  & 
     & "            MP", "          MRO2", "           MRP",  & 
     & "           MVK", "             N", "           N2O",  & 
     & "          N2O5", "            NO", "           NO2",  & 
     & "           NO3", "             O", "           O1D",  & 
     & "            O3", "          OClO", "          OCSg",  & 
     & "            OH", "           PAN", "           PMN",  & 
     & "           PO2", "            PP", "           PPN",  & 
     & "          PRN1", "          PRPE", "          PRPN",  & 
     & "          R4N1", "          R4N2", "          R4O2" /

      data (NAMESP2(JGAS,1), JGAS = 102, 117) / &
     & "           R4P", "          RA3P", "          RB3P",  & 
     & "          RCHO", "          RCO3", "         RCOOH",  & 
     & "          RIO1", "          RIO2", "           RIP",  & 
     & "           ROH", "            RP", "          VRO2",  & 
     & "           VRP", "          ACET", "            N2",  & 
     & "            O2" /
!
!.... Species indices for user within SMVGEAR
!
      IH2O      = 42
      INITROGEN = 116
      IOXYGEN   = 117
      IMGAS     = 118
!
!.... O2, N2, and M appear as reactants
!
      NMN2(1)   =  1
      NMO2(1)   =  4
      NMAIR(1)  =  0
      NM3BOD(1) =  0

      NREACN2(1, 1) = 3

      NREACO2(1:4, 1) = (/ 1 ,4 ,21 ,48 /)

      NREACAIR(:,:) = 0
      NREAC3B (:,:) = 0
      LGAS3BOD(:,:) = 0
!
!.... Species indices in thermal reactions
!
      data (IRM(1, i, 1), i=1,150) / &
     &   85,    85,    86,    86,    86,    86,    42,    39,    80,    80,   & 
     &   26,    26,    26,    21,    17,    18,    19,    47,    45,    46,   & 
     &   38,    38,    85,    53,    38,    82,    87,    53,    83,    90,   & 
     &   90,    53,    41,    53,    53,    42,    39,    32,    26,    73,   & 
     &   30,    53,    73,    73,    75,    75,    22,    79,    79,    83,   & 
     &   84,    83,    51,    82,    50,    53,    52,    52,    53,    82,   & 
     &   84,    83,    81,    49,    74,    83,    22,    29,    29,    29,   & 
     &   29,    29,    30,    30,    30,    30,    30,    30,    30,    30,   & 
     &   30,    30,    30,    28,    48,    55,    31,    31,    29,     7,   & 
     &    7,     7,     9,     9,     9,     9,     9,     9,     9,     9,   & 
     &   44,    22,    26,    22,    25,    24,    47,    45,    46,    25,   & 
     &   23,     1,     1,     1,    90,     2,     3,     3,     4,     4,   & 
     &    5,     5,     5,     5,     5,     6,     6,     6,     6,     6,   & 
     &   11,    11,    11,    12,    12,    33,    34,    34,    34,    35,   & 
     &   36,    36,    37,    37,    43,    43,    34,    53,    53,    56 /

      data (IRM(1, i, 1), i=151,300) / &
     &   56,    53,    57,    57,    57,    57,    58,    53,    59,    59,   & 
     &   59,    59,    60,    53,    61,    61,    61,    62,    63,    63,   & 
     &   63,    53,    64,    64,    64,    64,    65,    65,    65,    65,   & 
     &   53,    66,    66,    66,    66,    53,    67,    67,    67,    67,   & 
     &   67,    68,     1,     1,    34,    34,    70,    70,    70,    70,   & 
     &   70,    70,    70,    71,    71,    72,    72,    34,    53,    70,   & 
     &   70,    73,    76,    76,    77,    78,    78,    69,    90,    91,   & 
     &   92,    87,    90,    53,    73,    82,    95,    90,    53,    70,   & 
     &   70,    73,    82,    84,    87,    90,    90,    53,    70,    70,   & 
     &   73,    82,    90,    53,    70,    70,    73,    82,    82,    90,   & 
     &   90,    90,    84,    90,    53,    70,    73,    73,    83,    82,   & 
     &   53,    70,    70,    73,    82,    82,    53,    70,    70,    73,   & 
     &   82,    82,    90,    90,    90,    53,    70,    70,    73,    82,   & 
     &   82,    90,    81,    31,    10,    31,    48,    48,    81,    31,   & 
     &   10,    31,    48,    48,    31,    10,    31,    48,    10,    48 /

      data (IRM(1, i, 1), i=301,312) / &
     &   31,   10,   31,   48,   10,   48,   51,   84,   53,   83,  & 
     &   84,    81 /

      data (IRM(2, i, 1), i=1,150) / &
     &    0,    87,     0,     0,    87,    87,    86,    86,    86,    86,   & 
     &   86,    86,    86,    86,    86,    86,    86,    86,    86,    86,   & 
     &    0,    87,    90,    85,    53,    87,    90,    87,    87,    90,   & 
     &   90,    90,    90,    82,    53,    53,    90,    90,    90,    82,   & 
     &   73,    73,    73,    73,    90,    90,    90,     0,    82,    85,   & 
     &   85,    90,    90,    90,    90,    83,     0,    90,    84,    84,   & 
     &   90,    84,     0,    90,    90,    84,    84,    87,    39,    41,   & 
     &   53,    53,    85,    90,    90,    53,    53,    82,    83,    30,   & 
     &   30,    30,    30,     0,    90,    90,    85,    90,    31,    87,   & 
     &   53,    22,    85,    53,    82,    83,    30,    30,    30,     9,   & 
     &   90,    85,    29,    29,    90,    90,    90,    90,    90,    29,   & 
     &   90,    53,    73,    82,   115,    90,    84,    90,    84,    90,   & 
     &   53,    70,    70,    73,    82,    53,    70,    70,    73,    82,   & 
     &   84,    90,    29,    90,    90,    90,    34,    34,    82,    90,   & 
     &   90,    90,    84,    90,    90,    90,    53,    70,    70,    87 /

      data (IRM(2, i, 1), i=151,300) / &
     &   90,    57,    70,    70,    73,    82,    90,    59,    70,    70,   & 
     &   73,    82,    90,    61,    70,    70,    73,    90,    84,    87,   & 
     &   90,    64,    70,    70,    73,    82,    84,    84,    87,    90,   & 
     &   66,    70,    70,    73,    82,    67,    70,    73,    73,    83,   & 
     &   82,    90,    70,    70,    70,    70,    70,    73,    73,    83,   & 
     &   82,    93,    93,    84,    90,    84,    90,    73,    76,    76,   & 
     &   76,    76,    82,    82,    90,    87,    90,    90,   105,     0,   & 
     &    0,    92,    92,    93,    93,    93,     0,    94,    96,    96,   & 
     &   96,    96,    96,    97,    97,    97,    98,    99,    99,    99,   & 
     &   99,    99,   100,   101,   101,   101,   101,   101,   101,   102,   & 
     &  103,   104,   105,   107,   106,   106,   106,   106,   106,   106,   & 
     &  108,   108,   108,   108,   108,   108,   109,   109,   109,   109,   & 
     &  109,   109,   110,   111,   112,   113,   113,   113,   113,   113,   & 
     &  113,   114,     0,     0,     0,    48,    55,    54,     0,     0,   & 
     &    0,    48,    55,    54,     0,     0,    48,    55,    48,    54 /

      data (IRM(2, i, 1), i=301,312) / &
     &    0,    0,   48,   55,   48,   54,    0,   84,    0,    0,  & 
     &    0,     0 /

      data (IRM(3, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,    53,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(3, i, 1), i=151,300) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(3, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(4, i, 1), i=1,312) / 312*0 /

      data (IRM(5, i, 1), i=1,150) / &
     &   87,   117,   116,    85,   117,    85,    90,    38,   116,    82,   & 
     &   73,    22,    22,    29,    29,    29,    29,    29,    29,    29,   & 
     &   53,   117,    38,   117,    90,    83,    53,   117,    84,    42,   & 
     &   41,    42,    42,    83,    41,    42,    38,    38,    42,    22,   & 
     &   22,    75,    22,    22,    42,    22,    32,    82,   116,    82,   & 
     &   83,    51,    42,    50,    42,    52,    53,    42,    83,    83,   & 
     &   53,    81,    83,    42,    22,    82,    32,    30,    38,    48,   & 
     &   48,    30,    29,    29,    48,    55,    48,    29,    31,    29,   & 
     &   27,    29,    28,    30,    29,    30,    30,    55,    27,     9,   & 
     &   44,    32,     7,    54,     7,    10,     7,     7,     8,     7,   & 
     &    7,    32,    48,    32,    29,    29,    29,    29,    29,    32,   & 
     &    7,   103,    22,    53,     5,    42,    51,    22,    51,   101,   & 
     &   70,     2,    22,    22,    22,   104,   115,   115,   115,   115,   & 
     &   34,    34,    34,     1,     6,     3,     3,     3,     3,     3,   & 
     &   22,    32,    32,    32,    53,     2,    35,     2,    69,    22 /

      data (IRM(5, i, 1), i=151,300) / &
     &   53,    58,     2,    22,    22,    22,    57,    60,    22,     2,   & 
     &   22,    22,    59,    62,    36,     2,    22,    61,    59,    22,   & 
     &  109,    72,     2,     3,     3,     3,    66,    51,    22,    67,   & 
     &   62,    22,     2,    22,    22,    22,    22,    22,    22,    92,   & 
     &   22,    67,     2,    53,     2,     3,    73,     2,    22,    91,   & 
     &   73,     2,     3,    51,    42,    32,    32,     3,    77,     2,   & 
     &   22,    22,    51,    22,    76,     3,   113,    22,    42,    70,   & 
     &   67,    22,    32,    94,     3,     3,    83,    43,    98,     3,   & 
     &    2,     3,     3,    96,     3,    93,    96,   100,     3,     2,   & 
     &    3,     3,    42,   102,     2,     1,     1,     1,   100,    90,   & 
     &    1,   115,    51,    34,    87,    34,    22,    22,    95,    34,   & 
     &  110,     2,    22,    22,    51,    22,   110,     2,    22,    22,   & 
     &   51,    22,    57,    53,     3,    22,     2,    22,    22,    51,   & 
     &   22,    90,    51,    51,    51,    27,    27,     8,    51,    51,   & 
     &   51,    27,    27,     8,    51,    51,    27,    27,     8,     8 /

      data (IRM(5, i, 1), i=301,312) / &
     &   51,   51,   27,   27,    8,    8,   83,   83,   42,   50,  & 
     &   51,    51 /

      data (IRM(6, i, 1), i=1,150) / &
     &    0,     0,    85,   117,     0,   117,     0,    90,   117,     0,   & 
     &   90,    38,    39,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,    90,   117,    90,     0,   117,   117,    90,   117,    85,   & 
     &    0,   117,    53,    90,   117,    41,    42,     0,    73,    53,   & 
     &   29,   117,    74,    53,    73,    42,    42,    85,    85,   117,   & 
     &  117,     0,    84,     0,    83,     0,    83,    83,   117,     0,   & 
     &   83,     0,    84,    53,    53,    83,    51,   117,    48,    53,   & 
     &  117,    90,   117,    53,   117,   117,    87,    83,     0,   117,   & 
     &  117,    88,     0,     0,    42,    42,    84,    84,    84,   117,   & 
     &  117,    44,   117,   117,    83,     0,    88,    29,   117,   117,   & 
     &   42,    53,    73,    48,    53,     0,     0,     0,     0,    48,   & 
     &   53,     0,    53,    83,    42,    73,    70,    32,   101,     0,   & 
     &   73,    71,    53,    43,    70,     0,     2,    53,    22,    53,   & 
     &   51,    42,    48,     0,     0,    53,    53,    33,    53,    34,   & 
     &   32,    49,    51,    53,    72,    32,     0,    87,     0,    36 /

      data (IRM(6, i, 1), i=151,300) / &
     &   57,     0,    71,    32,    32,    32,    90,     0,    51,    83,   & 
     &   51,    51,     0,     0,    43,    83,    36,    83,     0,    32,   & 
     &    0,    73,    71,    70,    22,    70,     0,    67,    32,    76,   & 
     &    0,    72,    83,    53,    72,    32,    70,    53,   107,     0,   & 
     &   32,     0,   105,    73,     3,    53,     0,    22,    53,     0,   & 
     &   83,    43,    22,    64,    64,    51,    70,    22,     0,    71,   & 
     &   32,    32,     0,    32,     0,    22,     0,    70,   106,    83,   & 
     &   83,    53,    43,     0,    22,    22,   106,    90,     0,    22,   & 
     &   83,    22,    22,     0,    22,     0,     0,     0,    22,    83,   & 
     &   22,    22,    99,     0,    71,   115,   115,   115,     0,   101,   & 
     &   90,     6,   106,     0,   107,    73,    34,   107,     0,    83,   & 
     &    0,    71,    53,    53,     0,    53,     0,    71,    53,    53,   & 
     &    0,    53,   108,   105,    90,    36,    71,    36,    36,     0,   & 
     &   36,   105,     0,    55,    54,    51,    42,    42,     0,    55,   & 
     &   54,    51,    42,    42,    55,    54,    51,    42,    51,    42 /

      data (IRM(6, i, 1), i=301,312) / &
     &   55,   54,   51,   42,   51,   42,   90,  117,    0,   51,  & 
     &    0,     0 /

      data (IRM(7, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,    53,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,   117,     0,     0,     0,    83,   & 
     &   53,     0,   117,     0,     0,    90,    53,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,   117,    90,     0,   & 
     &    0,     0,     0,     0,     0,   117,    53,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,    53,     0,     0,     0,     0,     0,   117,     0,     0,   & 
     &    0,    90,     0,    53,     0,     0,     0,     0,     0,    53,   & 
     &    0,     0,    74,   105,     0,     0,     0,    42,     0,     0,   & 
     &    0,     0,    70,    53,    83,     0,     0,    73,    53,    83,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,    83,    90,   & 
     &   37,    90,    53,     0,     0,    49,     0,     0,     0,    37 /

      data (IRM(7, i, 1), i=151,300) / &
     &   67,     0,     0,    36,    36,    36,   105,     0,    53,   105,   & 
     &   53,    53,     0,     0,    73,   105,    43,    90,     0,    53,   & 
     &    0,     0,     0,    73,    53,    83,     0,     0,    53,     0,   & 
     &    0,    73,   105,    72,    83,    68,    73,    70,     0,     0,   & 
     &   70,     0,     0,   105,     0,    73,     0,     0,    73,     0,   & 
     &    0,   105,    53,     0,     0,    70,     0,    33,     0,     0,   & 
     &   43,    43,     0,    43,     0,    32,     0,    90,     0,     0,   & 
     &    0,    83,    83,     0,    43,    53,     0,    93,     0,    73,   & 
     &  105,    53,    83,     0,    32,     0,     0,     0,    73,   105,   & 
     &   53,    83,     0,     0,     0,     3,     3,     3,     0,   105,   & 
     &  105,    90,     0,     0,   112,     0,    53,     0,     0,     0,   & 
     &    0,     0,    56,    56,     0,    56,     0,     0,    56,    56,   & 
     &    0,    56,   109,     0,   106,    53,     0,    53,    53,     0,   & 
     &   53,   113,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(7, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(8, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &  117,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,   105,     0,     0,     0,     0,    53,     0,     0,   & 
     &    0,     0,    72,    70,   100,     0,     0,     0,    74,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   49,     0,     0,     0,     0,    73,     0,     0,     0,    43 /

      data (IRM(8, i, 1), i=151,300) / &
     &    0,     0,     0,    37,    37,    37,     0,     0,    65,     0,   & 
     &   65,    65,     0,     0,    83,     0,    53,   105,     0,    65,   & 
     &    0,     0,     0,     0,    70,   100,     0,     0,    72,     0,   & 
     &    0,    83,     0,    74,     0,    73,     0,     0,     0,     0,   & 
     &   73,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,    73,     0,     0,     0,     0,    53,     0,     0,   & 
     &   53,    53,     0,    53,     0,    53,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,    53,    83,     0,     0,     0,    83,   & 
     &    0,    74,     0,     0,    39,     0,     0,     0,    83,     0,   & 
     &   74,   101,     0,     0,     0,     6,     6,     6,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,    73,    71,     0,    83,     0,     0,    65,    65,   & 
     &    0,    65,     0,     0,     0,    70,     0,    70,    70,     0,   & 
     &   70,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(8, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(9, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,   111,     0,     0,     0,     0,    70,     0,     0,   & 
     &    0,     0,    73,    72,     0,     0,     0,     0,   111,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   53,     0,     0,     0,     0,    90,     0,     0,     0,    49 /

      data (IRM(9, i, 1), i=151,300) / &
     &    0,     0,     0,    43,    43,    43,     0,     0,    73,     0,   & 
     &   74,    78,     0,     0,     0,     0,    74,     0,     0,    78,   & 
     &    0,     0,     0,     0,    71,     0,     0,     0,    87,     0,   & 
     &    0,     0,     0,    83,     0,    87,     0,     0,     0,     0,   & 
     &   83,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,    74,     0,     0,   & 
     &   72,    72,     0,    72,     0,    72,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,    74,     0,     0,     0,     0,     0,   & 
     &    0,    83,     0,     0,    53,     0,     0,     0,   101,     0,   & 
     &   83,   105,     0,     0,     0,    34,    22,    34,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,    74,     0,     0,     0,     0,    73,    71,   & 
     &    0,    78,     0,     0,     0,    71,     0,    72,    71,     0,   & 
     &   72,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(9, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(10, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,    74,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   90,     0,     0,     0,     0,     0,     0,     0,     0,    72 /

      data (IRM(10, i, 1), i=151,300) / &
     &    0,     0,     0,    53,    53,    51,     0,     0,    78,     0,   & 
     &   78,    83,     0,     0,     0,     0,    83,     0,     0,    87,   & 
     &    0,     0,     0,     0,    74,     0,     0,     0,    90,     0,   & 
     &    0,     0,     0,   105,     0,    90,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &   73,   111,     0,    83,     0,    87,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,   105,     0,     0,     0,     0,     0,   & 
     &    0,   105,     0,     0,    73,     0,     0,     0,   105,     0,   & 
     &  101,     0,     0,     0,     0,    53,    34,    53,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,   111,     0,     0,     0,     0,    78,    74,   & 
     &    0,    83,     0,     0,     0,    72,     0,    73,    72,     0,   & 
     &   83,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(10, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(11, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,    87 /

      data (IRM(11, i, 1), i=151,300) / &
     &    0,     0,     0,    72,    71,    53,     0,     0,    83,     0,   & 
     &   83,     0,     0,     0,     0,     0,   105,     0,     0,    90,   & 
     &    0,     0,     0,     0,   111,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,   111,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,    90,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,   111,     0,     0,     0,     0,     0,   & 
     &    0,   111,     0,     0,    90,     0,     0,     0,     0,     0,   & 
     &  105,     0,     0,     0,     0,    71,    53,    71,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,   108,    78,   & 
     &    0,   108,     0,     0,     0,    90,     0,     0,    74,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(11, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(12, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,    90 /

      data (IRM(12, i, 1), i=151,300) / &
     &    0,     0,     0,    73,    72,    72,     0,     0,     0,     0,   & 
     &  105,     0,     0,     0,     0,     0,   111,     0,     0,    97,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &  111,     0,     0,     0,     0,    73,    71,    73,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,   108,   & 
     &    0,     0,     0,     0,     0,   105,     0,     0,   111,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(12, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(13, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(13, i, 1), i=151,300) / &
     &    0,     0,     0,     0,    74,    83,     0,     0,     0,     0,   & 
     &  111,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,   105,    73,    83,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,   111,   & 
     &    0,     0,     0,     0,     0,   114,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(13, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(14, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(14, i, 1), i=151,300) / &
     &    0,     0,     0,     0,   111,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,    74,   105,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(14, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(15, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(15, i, 1), i=151,300) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,   105,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(15, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

      data (IRM(16, i, 1), i=1,150) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(16, i, 1), i=151,300) / &
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,   111,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   & 
     &    0,     0,     0,     0,     0,     0,     0,     0,     0,     0 /

      data (IRM(16, i, 1), i=301,312) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,     0 /

!
!.... Stoichiometric coefficients in thermal reactions ....
!
      data (FKOEF(1, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(2, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(3, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(4, i, 1), i=1,312) / &
     & 312*1.0d0 /

      data (FKOEF(5, i, 1), i=1,100) / &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  2.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  3.000D+00,  &
     &  2.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00 /

      data (FKOEF(5, i, 1), i=101,200) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  3.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  5.000D-02,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D-01,  5.000D-01,  9.600D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  7.300D-01,  1.000D+00,  2.000D+00,  2.000D+00,  1.000D+00,  &
     &  5.000D-01,  1.000D+00,  1.000D+00,  1.000D+00,  1.200D-01,  &
     &  1.500D-01,  1.000D+00,  1.000D+00,  4.000D-01,  9.500D-01,  &
     &  3.500D-01,  5.000D-01,  1.000D+00,  1.500D-01,  1.000D+00,  &
     &  8.300D-01,  1.500D-01,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  7.500D-01,  5.000D-01,  1.000D+00,  9.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  9.300D-01,  1.000D+00,  1.000D+00,  7.000D-01,  5.300D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.250D+00,  1.000D+00,  &
     &  5.900D-01,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-01,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(5, i, 1), i=201,300) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  1.000D+00,  &
     &  1.700D-01,  1.000D+00,  1.000D+00,  1.700D-01,  1.000D+00,  &
     &  4.000D-02,  1.000D+00,  5.000D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  6.000D-01,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  1.000D+00,  1.000D+00,  7.910D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  &
     &  3.800D-01,  7.500D-01,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-02,  3.000D-02,  5.000D-02,  1.000D+00,  5.000D-01,  &
     &  5.000D-01,  7.910D-01,  1.000D+00,  1.000D+00,  3.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  1.130D+00,  1.000D+00,  &
     &  7.500D-01,  1.000D+00,  1.000D+00,  6.900D-01,  1.100D+00,  &
     &  1.000D+00,  6.900D-01,  5.000D-01,  1.000D+00,  5.000D-01,  &
     &  1.000D-01,  1.000D+00,  2.800D-01,  8.900D-01,  1.000D+00,  &
     &  2.800D-01,  5.000D-01,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(5, i, 1), i=301,312) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D+00,  5.000D-01,  5.000D-01,  &
     &  1.000D+00,  2.000D+00 /

      data (FKOEF(6, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(6, i, 1), i=101,200) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  5.000D-02,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  8.000D-01,  2.000D-01,  9.600D-01,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  &
     &  5.000D-01,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-01,  0.000D+00,  1.000D+00,  0.000D+00,  2.800D-01,  &
     &  4.400D-01,  0.000D+00,  1.000D+00,  2.900D-01,  1.500D-01,  &
     &  2.700D-01,  5.000D-01,  0.000D+00,  8.500D-01,  1.000D+00,  &
     &  4.250D-01,  8.500D-01,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  5.000D-01,  0.000D+00,  5.000D-02,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  7.500D-01,  &
     &  9.300D-01,  0.000D+00,  1.000D+00,  2.000D-01,  4.700D-01,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  1.000D+00,  &
     &  3.900D-01,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00 /

      data (FKOEF(6, i, 1), i=201,300) / &
     &  1.000D+00,  6.500D-01,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.500D-01,  0.000D+00,  1.000D+00,  &
     &  8.300D-01,  6.000D-01,  0.000D+00,  8.300D-01,  0.000D+00,  &
     &  8.000D-01,  0.000D+00,  5.000D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  7.910D-01,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.250D+00,  1.000D+00,  0.000D+00,  5.350D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  3.900D-01,  1.000D+00,  &
     &  9.500D-01,  3.900D-01,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  3.200D-01,  1.600D-01,  3.200D-01,  0.000D+00,  5.000D-01,  &
     &  5.000D-01,  2.090D-01,  1.000D+00,  0.000D+00,  3.000D-01,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  8.640D-01,  9.300D-01,  &
     &  0.000D+00,  8.640D-01,  1.000D-01,  1.000D+00,  5.000D-01,  &
     &  5.800D-01,  1.000D+00,  7.200D-01,  3.600D-01,  0.000D+00,  &
     &  7.200D-01,  5.000D-01,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00 /

      data (FKOEF(6, i, 1), i=301,312) / &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  5.000D-01,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=101,200) / &
     &  0.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.500D-01,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.000D-01,  3.000D-01,  9.600D-01,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  &
     &  1.300D-01,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  4.100D-01,  0.000D+00,  0.000D+00,  2.600D-01,  1.300D-01,  &
     &  2.400D-01,  5.000D-01,  0.000D+00,  8.000D-01,  1.000D+00,  &
     &  9.000D-01,  8.000D-01,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  5.000D-01,  0.000D+00,  6.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  &
     &  9.300D-01,  0.000D+00,  0.000D+00,  2.750D-01,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  5.000D-01,  2.000D+00,  &
     &  4.100D-01,  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=201,300) / &
     &  0.000D+00,  3.500D-01,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  &
     &  8.300D-01,  6.000D-01,  0.000D+00,  8.300D-01,  0.000D+00,  &
     &  5.000D-02,  0.000D+00,  5.000D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.600D-01,  &
     &  1.000D+00,  0.000D+00,  2.090D-01,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  5.000D-01,  2.000D+00,  0.000D+00,  4.200D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  5.000D-01,  2.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  3.200D-01,  1.600D-01,  3.200D-01,  0.000D+00,  5.000D-01,  &
     &  5.000D-01,  7.910D-01,  0.000D+00,  0.000D+00,  7.000D-01,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  1.270D-01,  6.000D-02,  &
     &  0.000D+00,  1.270D-01,  4.000D-01,  0.000D+00,  5.000D-01,  &
     &  1.000D-01,  0.000D+00,  2.800D-01,  6.400D-01,  0.000D+00,  &
     &  2.800D-01,  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(7, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  7.500D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  5.000D-02,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  8.000D-01,  3.000D-01,  4.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.300D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.800D-01,  9.000D-02,  &
     &  1.700D-01,  0.000D+00,  0.000D+00,  1.000D-01,  0.000D+00,  &
     &  5.000D-02,  1.000D-01,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  5.000D-01,  5.000D-01,  0.000D+00,  3.870D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  5.000D-01,  &
     &  7.000D-02,  0.000D+00,  0.000D+00,  8.000D-01,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  3.900D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  6.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  6.500D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.500D-01,  3.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.800D-01,  9.000D-02,  1.800D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  2.500D-01,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  2.880D-01,  1.400D-01,  &
     &  0.000D+00,  2.880D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.800D-01,  0.000D+00,  7.200D-01,  3.600D-01,  0.000D+00,  &
     &  7.200D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(8, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  9.500D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  5.000D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  7.700D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  3.600D-01,  1.800D-01,  &
     &  3.300D-01,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.500D-01,  5.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  1.590D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.000D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  1.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  &
     &  1.700D-01,  2.500D-01,  0.000D+00,  1.700D-01,  0.000D+00,  &
     &  8.200D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  3.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  3.000D-01,  0.000D+00,  &
     &  1.000D+00,  5.700D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  3.200D-01,  7.500D-01,  3.200D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  2.500D-01,  &
     &  0.000D+00,  4.020D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.900D-01,  0.000D+00,  2.800D-01,  2.500D-01,  0.000D+00,  &
     &  2.800D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(9, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  5.000D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.300D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  6.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  1.000D+00,  &
     &  8.000D-02,  0.000D+00,  0.000D+00,  5.000D-02,  0.000D+00,  &
     &  3.000D-02,  1.150D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.150D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  4.400D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.500D-01,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  2.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  9.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  3.050D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  5.700D-01,  0.000D+00,  &
     &  1.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.700D-01,  1.600D-01,  2.700D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  4.020D-01,  2.500D-01,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D-01,  0.000D+00,  1.000D+00,  1.400D-01,  0.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(10, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  3.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  5.800D-01,  2.500D-01,  &
     &  9.200D-01,  0.000D+00,  0.000D+00,  1.500D-01,  0.000D+00,  &
     &  5.750D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  2.700D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  8.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  1.350D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  5.400D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.900D-01,  6.400D-01,  1.900D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.360D-01,  2.000D-01,  &
     &  0.000D+00,  1.360D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  6.800D-01,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(11, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  2.900D-01,  &
     &  5.300D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  7.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.180D+00,  3.500D-01,  1.800D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  7.000D-02,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  3.000D-02,  0.000D+00,  0.000D+00,  2.500D-01,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(12, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  9.200D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.300D-01,  9.000D-02,  1.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D-01,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(13, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  2.500D-01,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  1.300D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(14, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  7.000D-02,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(15, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=1,100) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=101,200) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=201,300) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  2.500D-01,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00 /

      data (FKOEF(16, i, 1), i=301,312) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00 /

!
!.... Species indices in photolysis reactions ....
!
      data (IRM(1, i, 1), i=313,393) / &
     &  117,   87,   87,   53,   42,   82,   80,   83,   41,   75,  & 
     &   22,   22,   51,   50,   52,   52,   84,   84,   81,   81,  & 
     &   27,   88,   28,   55,   31,   31,    8,    9,   54,   10,  & 
     &   10,   25,   13,   24,   20,   21,   17,   18,   19,   45,  & 
     &   46,   23,   16,   14,   40,   15,    3,    3,   91,  105,  & 
     &  115,   71,   36,   37,   37,   37,   72,   72,   78,   78,  & 
     &   78,   65,   65,   43,   60,   98,   35,  103,  104,  102,  & 
     &   94,  112,  110,   58,   62,  114,   77,   68,  100,   69,  & 
     &   89 /

      data (IRM(2, i, 1), i=313,393) / &
     & 81*0 /

      data (IRM(3, i, 1), i=313,393) / &
     & 81*0 /

      data (IRM(4, i, 1), i=313,393) / &
     & 81*0 /

      data (IRM(5, i, 1), i=313,393) / &
     &   85,   85,   86,   85,   38,   79,  116,   82,   90,   22,  & 
     &   32,   32,   83,   82,   84,   53,   83,   82,   83,   82,  & 
     &   29,   30,   29,   29,   29,   30,    7,    7,    7,    7,  & 
     &    9,   29,   29,   29,   29,   29,   29,   29,   29,   29,  & 
     &   29,    7,    7,    7,    7,    7,   32,   26,   70,   32,  & 
     &   70,   34,   22,   32,   32,   22,   32,    3,   32,   22,  & 
     &   67,   53,   22,   22,   53,   53,    3,   53,   53,   53,  & 
     &   53,    3,   22,   32,   53,   22,   22,   53,    1,   73,  & 
     &   32 /

      data (IRM(6, i, 1), i=313,393) / &
     &    0,  117,  117,   90,   90,   85,   86,   85,    0,   53,  & 
     &   38,   39,   90,   90,   90,   83,   87,  117,   84,   84,  & 
     &    0,   85,  117,   90,   84,   83,   29,   85,   90,   84,  & 
     &   83,   73,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,   73,    0,    0,    0,   29,   53,   32,   83,   34,  & 
     &   73,   70,   32,   39,   53,   32,   53,   32,   97,   32,  & 
     &   73,   67,   32,   53,   83,   83,   53,   90,   90,   90,  & 
     &   90,   53,   53,   36,   83,   36,   32,   90,  115,   90,  & 
     &    0 /

      data (IRM(7, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,  & 
     &   53,    0,    0,    0,    0,    0,    0,    0,    0,   85,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,   73,    0,    0,   53,  & 
     &    0,    0,   53,    0,    0,    0,   70,    0,    0,   53,  & 
     &    0,    0,   53,   70,   90,   90,   90,  105,  105,  105,  & 
     &  105,   90,   56,   39,   90,   53,   43,  105,    3,    0,  & 
     &    0 /

      data (IRM(8, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,   70,  & 
     &    0,    0,   70,    0,  105,  105,    0,    0,    0,    0,  & 
     &    0,    0,   65,   43,  105,   70,   53,    0,    6,    0,  & 
     &    0 /

      data (IRM(9, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,   72,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,   78,   53,    0,   72,   72,    0,   34,    0,  & 
     &    0 /

      data (IRM(10, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,   90,   72,    0,   90,   90,    0,   53,    0,  & 
     &    0 /

      data (IRM(11, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,  108,   90,    0,    0,    0,    0,   71,    0,  & 
     &    0 /

      data (IRM(12, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,   73,    0,  & 
     &    0 /

      data (IRM(13, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,   83,    0,  & 
     &    0 /

      data (IRM(14, i, 1), i=313,393) / &
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,  & 
     &    0,    0,    0,    0,    0,    0,    0,    0,  105,    0,  & 
     &    0 /

      data (IRM(15, i, 1), i=313,393) / 81*0 /
      data (IRM(16, i, 1), i=313,393) / 81*0 /
!
!.... Stoichiometric coefficients in photolysis reactions ....
!
      data (FKOEF(1, i, 1), i=313,393) / &
     & 81*1.0d0 /

      data (FKOEF(2, i, 1), i=313,393) / &
     & 81*1.0d0 /

      data (FKOEF(3, i, 1), i=313,393) / &
     & 81*1.0d0 /

      data (FKOEF(4, i, 1), i=313,393) / &
     & 81*1.0d0 /

      data (FKOEF(5, i, 1), i=313,393) / &
     &  2.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  2.000D+00,  1.000D+00,  2.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  4.000D+00,  3.000D+00,  3.000D+00,  &
     &  2.000D+00,  3.000D+00,  2.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  2.000D-01,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  6.900D-01,  6.700D-01,  1.000D+00,  &
     &  2.800D-01,  1.700D-01,  1.000D+00,  5.000D-02,  1.000D+00,  &
     &  1.000D+00 /

      data (FKOEF(6, i, 1), i=313,393) / &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  0.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  2.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  8.640D-01,  2.600D-01,  1.000D+00,  &
     &  7.200D-01,  8.300D-01,  1.000D+00,  3.200D-01,  1.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(7, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  1.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.800D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  &
     &  1.000D+00,  1.000D+00,  1.270D-01,  1.900D-01,  1.000D+00,  &
     &  2.800D-01,  8.300D-01,  1.000D+00,  3.200D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(8, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.000D-01,  0.000D+00,  1.000D+00,  &
     &  1.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  2.880D-01,  3.600D-01,  1.000D+00,  &
     &  7.200D-01,  1.000D+00,  0.000D+00,  1.800D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(9, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  8.000D-01,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  4.020D-01,  1.000D+00,  0.000D+00,  &
     &  2.800D-01,  1.700D-01,  0.000D+00,  3.200D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(10, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.000D+00,  5.800D-01,  0.000D+00,  &
     &  1.000D+00,  1.000D+00,  0.000D+00,  2.700D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(11, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  1.360D-01,  1.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.900D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(12, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.800D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(13, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(14, i, 1), i=313,393) / &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  0.000D+00,  &
     &  0.000D+00,  0.000D+00,  0.000D+00,  1.300D-01,  0.000D+00,  &
     &  0.000D+00 /

      data (FKOEF(15, i, 1), i=313,393) / 81*0.0d0 /

      data (FKOEF(16, i, 1), i=313,393) / 81*0.0d0 /


!                                  --^--

