!=======================================================================
!
! $Id: setkin_depos.h $
!
! CODE DEVELOPER
!   Peter Connell, LLNL
!   connell2@llnl.gov
!
! FILE
!   setkin_depos.h
!
! DESCRIPTION
!   This include file contains physical information about each species which
!   will be used in the deposition routines. It includes an integer declaring
!   aerosol species (aerosol=1 means it is an aerosol, aerosol=0 means it is
!   a gas). There is also a Henry's law constant and oxidizing potential for
!   each species.
!
!  Input mechanism:        GeosCCM_Combo_2015mechanism_orig.txt
!  Reaction dictionary:    GMI_reactions_JPL19.db
!  Setkin files generated: Mon May 12 15:44:10 2025
!
!=======================================================================

      integer      :: aerosol         (1:NSP)

      real*8, save :: hstar_dry       (1:NSP)
      real*8, save :: hstar_wet       (1:NSP)
      real*8, save :: oxidize         (1:NSP)
      real*8, save :: delH_298_over_R_dry (1:NSP)
      real*8, save :: delH_298_over_R_wet (1:NSP)
      real*8, save :: retention_eff   (1:NSP)
!
      data aerosol (1:NSP) / &
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  & 
     &   0,    0,    0,    0,    0,    0,    0,    0,    0 /
!
      data hstar_dry (1:NSP) / &
     &   0.000D+00,   4.100D+03,   1.100D+01,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   3.450D-02,   9.800D-01,   0.000D+00,   1.000D+20,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   3.230D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   9.290D-02,   0.000D+00,   2.300D+00,   7.100D-01,  &
     &   1.000D+06,   0.000D+00,   1.900D+02,   0.000D+00,   0.000D+00,  &
     &   4.000D+04,   4.190D+05,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   8.700D+04,   0.000D+00,   2.930D+03,   7.100D+15,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   3.200D+12,   8.900D+03,   4.860D+01,  &
     &   1.000D+14,   3.950D+03,   6.900D+02,   1.300D+03,   6.600D+02,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   6.500D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   8.370D+02,   0.000D+00,  &
     &   0.000D+00,   3.500D+03,   0.000D+00,   0.000D+00,   3.000D+02,  &
     &   0.000D+00,   0.000D+00,   4.100D+01,   0.000D+00,   0.000D+00,  &
     &   2.100D+00,   0.000D+00,   1.200D-02,   3.800D-02,   0.000D+00,  &
     &   0.000D+00,   1.030D-02,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   2.800D+00,   2.800D+00,   0.000D+00,   0.000D+00,   2.800D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   2.800D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.700D+06,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.000D+05,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00 /
!
      data hstar_wet (1:NSP) / &
     &   0.000D+00,   4.100D+03,   1.100D+01,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   3.450D-02,   9.800D-01,   0.000D+00,   1.000D+20,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   3.230D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   9.290D-02,   0.000D+00,   2.300D+00,   7.100D-01,  &
     &   1.000D+06,   0.000D+00,   1.900D+02,   0.000D+00,   0.000D+00,  &
     &   4.000D+04,   4.190D+05,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   8.700D+04,   0.000D+00,   0.000D+00,   7.100D+13,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   3.200D+12,   8.900D+03,   4.860D+01,  &
     &   1.000D+14,   3.950D+03,   6.900D+02,   1.300D+03,   6.600D+02,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   8.370D+02,   0.000D+00,  &
     &   0.000D+00,   3.500D+03,   0.000D+00,   0.000D+00,   3.000D+02,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   2.100D+00,   0.000D+00,   0.000D+00,   3.800D-02,   0.000D+00,  &
     &   0.000D+00,   1.030D-02,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.700D+06,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   2.700D+01,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00 /
!
      data delH_298_over_R_dry (1:NSP) / &
     &   0.000D+00,  -6.200D+03,  -6.300D+03,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -1.800D+03,  -5.630D+03,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -7.100D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -7.590D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,  -1.290D+04,   0.000D+00,   0.000D+00,  &
     &  -4.630D+03,  -7.480D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &  -7.290D+03,   0.000D+00,   0.000D+00,  -1.020D+04,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,  -1.100D+04,  -6.100D+03,  -4.800D+03,  &
     &   0.000D+00,  -8.400D+03,   0.000D+00,   0.000D+00,  -5.880D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,  -5.310D+03,   0.000D+00,  &
     &   0.000D+00,  -7.545D+03,   0.000D+00,   0.000D+00,  -5.280D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &  -3.400D+03,   0.000D+00,  -2.360D+03,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -2.830D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &  -5.730D+03,  -5.730D+03,   0.000D+00,   0.000D+00,  -5.730D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  -5.730D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  -5.300D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00 /
!
      data delH_298_over_R_wet (1:NSP) / &
     &   0.000D+00,  -6.200D+03,  -6.300D+03,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -1.800D+03,  -5.630D+03,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -7.100D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -7.590D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,  -1.290D+04,   0.000D+00,   0.000D+00,  &
     &  -4.630D+03,  -7.480D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &  -7.290D+03,   0.000D+00,   0.000D+00,  -1.020D+04,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,  -1.100D+04,  -6.100D+03,  -4.800D+03,  &
     &   0.000D+00,  -8.400D+03,   0.000D+00,   0.000D+00,  -5.880D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,  -5.310D+03,   0.000D+00,  &
     &   0.000D+00,  -7.545D+03,   0.000D+00,   0.000D+00,  -5.280D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &  -3.400D+03,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,  -2.830D+03,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  -5.300D+03,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00 /
!
      data oxidize (1:NSP) / &
     &   0.000D+00,   1.000D+00,   1.000D+00,   1.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   1.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   1.000D+00,   0.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.000D-01,  &
     &   0.000D+00,   1.000D-01,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   1.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   1.000D-01,   1.000D+00,   0.000D+00,  &
     &   0.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   1.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,   1.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   1.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00 /
!
      data retention_eff (1:NSP) / &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   2.000D-02,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   2.000D-02,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   5.000D-02,   0.000D+00,   0.000D+00,   1.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   1.000D+00,   0.000D+00,   0.000D+00,  &
     &   1.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   2.000D-02,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   2.000D-02,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   2.000D-02,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00,  &
     &   0.000D+00,   0.000D+00,   0.000D+00,   0.000D+00 /
!
!                                  --^--
!
